import openpyxl
import pybedtools


filename = "reporters.bed"
print("Writing", filename)
stream = open(filename, 'w')

path = "/osc-fs_home/mdehoon/Data/Fantom5/Robin/TableS3.xlsx"
print("Reating", path)
workbook = openpyxl.load_workbook(path)
assert len(workbook.sheetnames) == 1
assert workbook.sheetnames[0] == 'suppl_table.txt'
sheet = workbook.active
assert sheet['A1'].value == "Table S3: Summary of Hela and hepG2 DualGo validation, and plas,id construction sequences"
assert sheet['A2'].value == "Name"
assert sheet['B2'].value == "Type"
assert sheet['C2'].value == "HeLa.rep1.fc"
assert sheet['D2'].value == "HeLa.rep2.fc"
assert sheet['E2'].value == "HeLa.rep3.fc"
assert sheet['F2'].value == "Hela.mean.fc"
assert sheet['G2'].value == "HeLa.std.fc"
assert sheet['H2'].value == "HeLa.t.test.p"
assert sheet['I2'].value == "HepG2.rep1.fc"
assert sheet['J2'].value == "HePG2.rep2.fc"
assert sheet['K2'].value == "HepG2.rep3.fc"
assert sheet['L2'].value == "HepG2.mean.fc"
assert sheet['M2'].value == "HepG2.std.fc"
assert sheet['N2'].value == "HepG2.t.test.p"
assert sheet['O2'].value == "Fw_Combined seq"
assert sheet['P2'].value == "Rv connected seq"
assert sheet['Q2'].value == "amplicon position"
assert sheet['R2'].value == "amplicon size"
lines = iter(sheet)
line = next(lines)
line = next(lines)
for line in lines:
    name = line[0].value
    if name == 'Heintzman_et_al_H3':
        continue
    if name == 'Heintzman_et_al_H9':
        continue
    hela_pvalue = line[7].value
    hepg2_pvalue = line[13].value
    pvalue = min(hela_pvalue, hepg2_pvalue)
    try:
        chromosome, locus = name.split(":")
    except ValueError:
        chromosome, number = name.split(".")
        number = int(number)
        continue
    start, end = locus.split("-")
    start = int(start)
    end = int(end)
    fields = [chromosome, start, end, name, str(pvalue), "."]
    interval = pybedtools.create_interval_from_list(fields)
    stream.write(str(interval))

stream.close()
